package aln.SpawnCommands;

import java.util.Arrays;
import java.util.List;

import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CommandSpawnQuery implements ICommand {

  @Override
  public int compareTo(Object o) {
    return 0;
  }
  
  @Override
  public String getCommandName() {
    //return "spawn?";
	return Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn?");
  }
  
  @Override
  public String getCommandUsage(ICommandSender icommandsender) {
    return "/"+ Do.getConfigArrayValue(SpawnCommands.commandNames ,"spawn?") +" - displays with world and bed spawn coordinates.";
  }
  
  @Override
  public List getCommandAliases() {
    return Arrays.asList(new String[] { });
  }
  
  @Override
  public void processCommand(ICommandSender icommandsender, String[] params) {
    if(icommandsender instanceof EntityPlayer) {
      EntityPlayer player = (EntityPlayer) icommandsender;
      World world = player.worldObj;
      if ( world.isRemote ) { return; }
      
      SpawnCommands.loadCommandPermissionsConfig();
      SpawnCommands.loadMiscConfig();
      
      // command permissions. "no" is handled by not registering the command at all. "op" and "enable" are handled here. "all" is the default.
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn?").equalsIgnoreCase("op") && (! Do.IsOp(player)) ) 
      { Do.Say(player,"Op only command.  You are not an op."); return; }
      if ( Do.getConfigArrayValue(SpawnCommands.commandPermissions, "spawn?").equalsIgnoreCase("enabled") && (! SpawnCommands.advancedCommandsAreEnabled() ) ) 
      { Do.Say(player,"Advanced spawn commands are not enabled."); return; }
      
      if (params.length > 0) { SpawnCommands.showHelp(player); return; }

      int originDim = world.provider.dimensionId;
      int bedDim;
      boolean bedIsInThisDim = false;
      ChunkCoordinates bedCC = null;
      
      Do.Say(player," ");
      
      String sayit="";
      if ( originDim != 0 ) { sayit=" in this dimension."; }
      Do.Say(player,player.getGameProfile().getName() +" is at ( x"
        +Math.round(player.posX - .5)+" y"
        +Math.round(player.posY - .5)+" z"
        +Math.round(player.posZ - .5)+" )"
        +sayit);
      
      // is there a bed location defined in the local dimension?
      bedCC = player.getBedLocation(originDim);
      if ( bedCC == null ) { bedIsInThisDim = false; } else { bedIsInThisDim = true; }
      if ( bedIsInThisDim ) { bedDim = originDim; } else { bedDim = 0; }
      if (  Do.isModIDLoaded("TwilightForest") 
         && (world.provider.getDimensionName().equals("Twilight Forest")) 
         && bedIsInThisDim 
         ) 
      { bedDim = 0; bedIsInThisDim = false; } // exception for TwilightForest mod
      
      if ( ( originDim != 0) && (bedDim == originDim) && (bedCC != null) ) {
        Do.Say(player,"Bed/home in this dimension is at ( x"+bedCC.posX+" y"+bedCC.posY+" z"+bedCC.posZ+" )" );
      }
      
      ChunkCoordinates pxyz = player.worldObj.getSpawnPoint();
      double px = pxyz.posX;
      double py = pxyz.posY;
      double pz = pxyz.posZ;
      Do.Say(player,"Main world spawn coordinates ( x" + (int)px + " y" + (int)py + " z" + (int)pz + " )");
      // int d = player.worldObj.provider.dimensionId; // use if beds are ever usable in other dimensions
      bedCC = player.getBedLocation(0); // using only main world dim0 for bed, or use 'd' for above.
      if ( bedCC != null) { 
        Do.Say(player,"Main world bed/home spawn point ( x" + (int)bedCC.posX +" y"+ (int)bedCC.posY +" z"+ (int)bedCC.posZ + " )");
      } else {
        Do.Say(player,"Main world bed/home spawn point is not set.");
      }
    }
  }

  @Override
  public boolean canCommandSenderUseCommand(ICommandSender icommandsender) {
    return true;
  }

  @Override
  //public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) { // mc1.8
  public List addTabCompletionOptions(ICommandSender icommandsender, String[] astring) { // mc1.7.10
    return null;
  }

  @Override
  public boolean isUsernameIndex(String[] astring, int i) {
    return false;
  }

}
